/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.tabbedPane;

import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.tabbedPane.IVWTabClosedListener;
import filenet.vw.toolkit.utils.uicontrols.tabbedPane.VWCloseableTabComponent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;

public class VWCloseableTabbedPane
extends JTabbedPane
implements ActionListener,
MouseListener {
    private JPopupMenu m_actionPopupMenu = null;
    private JMenuItem m_closeItem = new JMenuItem(VWResource.s_close);
    private Method m_indexOfTabComponentMethod = null;
    private Method m_getTabComponentAtMethod = null;
    private Method m_setTabComponentAtMethod = null;

    public VWCloseableTabbedPane() {
        super(1, 1);
        this.m_closeItem.addActionListener(this);
        this.m_actionPopupMenu = new JPopupMenu();
        this.m_actionPopupMenu.removeAll();
        this.m_actionPopupMenu.add(this.m_closeItem);
        this.initializeMethodReferences();
        this.addMouseListener(this);
    }

    public synchronized void addTabClosedListener(IVWTabClosedListener listener) {
        this.listenerList.add(IVWTabClosedListener.class, listener);
    }

    public synchronized void removeTabClosedListener(IVWTabClosedListener listener) {
        this.listenerList.remove(IVWTabClosedListener.class, listener);
    }

    public void setTabPlacement(int tabPlacement) {
        if (tabPlacement != 1) {
            throw new IllegalArgumentException("illegal tab placement: must be TOP");
        }
        super.setTabPlacement(tabPlacement);
    }

    public void setTabLayoutPolicy(int tabLayoutPolicy) {
        if (tabLayoutPolicy != 1) {
            throw new IllegalArgumentException("illegal tab layout policy: must be SCROLL_TAB_LAYOUT");
        }
        super.setTabLayoutPolicy(tabLayoutPolicy);
    }

    public void addTab(String title, Component component) {
        this.addTab(title, null, component, null, true);
    }

    public void addTab(String title, Component component, boolean bIsCloseable) {
        this.addTab(title, null, component, null, bIsCloseable);
    }

    public void addTab(String title, Icon icon, Component component) {
        this.addTab(title, icon, component, null, true);
    }

    public void addTab(String title, Icon icon, Component component, String toolTip) {
        this.addTab(title, icon, component, toolTip, true);
    }

    public void addTab(String title, Icon icon, Component component, String toolTip, boolean bIsCloseable) {
        if (this.m_setTabComponentAtMethod != null) {
            try {
                super.addTab(null, component);
                int nNewTabIndex = this.getTabCount() - 1;
                if (toolTip != null) {
                    this.setToolTipTextAt(nNewTabIndex, toolTip);
                }
                Object[] arglist = new Object[]{new Integer(nNewTabIndex), new VWCloseableTabComponent(this, title, icon, bIsCloseable)};
                this.m_setTabComponentAtMethod.invoke((Object)this, arglist);
                this.setSelectedIndex(0);
                this.setSelectedComponent(component);
                return;
            }
            catch (IllegalAccessException ex) {
            }
            catch (InvocationTargetException ex) {
                // empty catch block
            }
            this.removeTabAt(this.getTabCount() - 1);
        }
        super.addTab(title, icon, component, toolTip);
    }

    public int getIndexOfTabComponent(Component tabComponent) {
        if (this.m_indexOfTabComponentMethod != null) {
            try {
                Object[] arglist = new Object[]{tabComponent};
                Object retObj = this.m_indexOfTabComponentMethod.invoke((Object)this, arglist);
                return (Integer)retObj;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public void setIconAt(int nTabIndex, Icon icon) {
        if (this.m_getTabComponentAtMethod != null) {
            try {
                Object[] arglist = new Object[]{new Integer(nTabIndex)};
                Object retObj = this.m_getTabComponentAtMethod.invoke((Object)this, arglist);
                if (retObj != null && retObj instanceof VWCloseableTabComponent) {
                    ((VWCloseableTabComponent)retObj).setIcon(icon);
                }
            }
            catch (IllegalAccessException ex) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else {
            super.setIconAt(nTabIndex, icon);
        }
    }

    public void setTitleAt(int nTabIndex, String title) {
        if (this.m_getTabComponentAtMethod != null) {
            try {
                Object[] arglist = new Object[]{new Integer(nTabIndex)};
                Object retObj = this.m_getTabComponentAtMethod.invoke((Object)this, arglist);
                if (retObj != null && retObj instanceof VWCloseableTabComponent) {
                    ((VWCloseableTabComponent)retObj).setTitle(title);
                }
            }
            catch (IllegalAccessException ex) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else {
            super.setTitleAt(nTabIndex, title);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_closeItem)) {
            this.fireTabClosedEvent(this.getSelectedIndex());
        }
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
        int nTabIndex;
        if (event.isPopupTrigger() && this.m_actionPopupMenu != null && (nTabIndex = this.getUI().tabForCoordinate(this, event.getX(), event.getY())) != -1) {
            if (this.m_getTabComponentAtMethod != null) {
                try {
                    Object[] arglist = new Object[]{new Integer(nTabIndex)};
                    Object retObj = this.m_getTabComponentAtMethod.invoke((Object)this, arglist);
                    if (retObj != null && retObj instanceof VWCloseableTabComponent && !((VWCloseableTabComponent)retObj).isCloseable()) {
                        return;
                    }
                }
                catch (IllegalAccessException ex) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            this.m_actionPopupMenu.show(this, event.getX(), event.getY());
        }
    }

    protected void fireTabClosedEvent(int nTabIndex) {
        EventListener[] closeListeners = this.getListeners(IVWTabClosedListener.class);
        for (int i = 0; i < closeListeners.length; ++i) {
            ((IVWTabClosedListener)closeListeners[i]).closeOperation(nTabIndex);
        }
    }

    private void initializeMethodReferences() {
        Class<JTabbedPane> superClass = JTabbedPane.class;
        if (superClass == null) {
            return;
        }
        try {
            this.m_indexOfTabComponentMethod = superClass.getMethod("indexOfTabComponent", Component.class);
        }
        catch (NoSuchMethodException ex) {
            this.m_indexOfTabComponentMethod = null;
        }
        try {
            this.m_getTabComponentAtMethod = superClass.getMethod("getTabComponentAt", Integer.TYPE);
        }
        catch (NoSuchMethodException ex) {
            this.m_getTabComponentAtMethod = null;
        }
        try {
            this.m_setTabComponentAtMethod = superClass.getMethod("setTabComponentAt", Integer.TYPE, Component.class);
        }
        catch (NoSuchMethodException ex) {
            this.m_setTabComponentAtMethod = null;
        }
    }
}

